<?php
$type_name = $item_type->name;
if ($type_name != '') {
    $type_name = ': &quot;' . html_escape($type_name) . '&quot; ';
} else {
    $type_name = '';
}
$title = __('Edit Item Type #%s', $item_type->id) . $type_name;

echo head(['title'=> $title,'bodyclass'=>'item-types']);
echo flash();
?>

<form method="post" action="">
    <?php include 'form.php';?>
    <section class="three columns omega">
        <div id="save" class="panel">
            <input type="submit" class="full-width green button" name="submit" value="<?php echo __('Save Changes'); ?>">
            <?php if (is_allowed('ItemTypes', 'delete')): ?>
                <?php echo link_to($item_type, 'delete-confirm', __('Delete'), ['class' => 'full-width red button delete-confirm']); ?>
            <?php endif; ?>
            <?php fire_plugin_hook("admin_item_types_panel_buttons", ['view'=>$this, 'record'=>$item_type]); ?>
            <?php fire_plugin_hook("admin_item_types_panel_fields", ['view'=>$this, 'record'=>$item_type]); ?>
        </div>
    </section>
</form>

<script type="text/javascript">
Omeka.addReadyCallback(Omeka.ItemTypes.enableSorting);
Omeka.manageDrawers('#type-elements');
</script>
<?php echo foot(); ?>
